%   Copyright  2020 University of Extremadura (UEx)
%
% loadDeploymentRss
%
%  Input:
%   set: Current deployment information 
%   rssMatrix: RSSI presented as RSSI fingerprinting matrix. Each row is a
%   RP point and each column is a beacon (Slot)
%   coordMatrix: Coordinates of the reference points in the before matrix
%   as x y z.
%   idxRadioMap: indexes with the propoused split between train and test 
%   idxEval: indexes with the propoused split between train and test 
%
%  Output:
%   data: Structure with the selected data
% -----------------------------------------

function [rssTrnMat,rssTstMat,coorTrnMat,coorTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxRadioMap,idxEval)


% Output matrix are crated
rssTrnMat = zeros(sum(idxRadioMap),size(rssMatrix,2));
rssTstMat = zeros(sum(idxEval),size(rssMatrix,2));
coorTrnMat = zeros(sum(idxRadioMap),3);
coorTstMat = zeros(sum(idxEval),3);

% Original matrix is divided into test and traning matrix
rssTrnMat =  rssMatrix(logical(idxRadioMap),:);
rssTstMat =  rssMatrix(logical(idxEval),:);
coorTrnMat = coordMatrix(logical(idxRadioMap),:);
coorTstMat = coordMatrix(logical(idxEval),:);
end

